<?php 
include 'conexao.php';

$aluno_id = $_GET['aluno_id'] ?? '';

if (!$aluno_id) {
    die("Aluno não especificado.");
}

// Buscar dados pessoais e termo
$stmt = $conn->prepare("
    SELECT a.nome, t.filiacao, t.naturalidade, t.provincia, t.data_nascimento,
           t.bi_numero, t.bi_emissao_data, t.bi_emissao_local
    FROM alunos a
    LEFT JOIN termos t ON a.id = t.aluno_id
    WHERE a.id = ?
");
$stmt->bind_param("i", $aluno_id);
$stmt->execute();
$aluno = $stmt->get_result()->fetch_assoc();
if (!$aluno) die("Dados do aluno não encontrados.");

// Anos lectivos fixos fictícios
$anos = [
    ['ano_lectivo' => '2021/2022', 'turma' => '10ª A'],
    ['ano_lectivo' => '2022/2023', 'turma' => '11ª A'],
    ['ano_lectivo' => '2023/2024', 'turma' => '12ª A'],
    ['ano_lectivo' => '2024/2025', 'turma' => '13ª A'],
];

// Disciplinas
$disciplinas = [
    'L. Portuguesa', 'Inglês', 'Francês', 'Matemática', 'Física', 'Química',
    'Biologia', 'Psicologia', 'Exp. Motora', 'Exp. Plástica', 'Exp. Musical'
];

function buscarNotasReais($conn, $aluno_id, $ano_lectivo, $disciplinas) {
    $notas = [];

    $stmt = $conn->prepare("
        SELECT d.nome AS disciplina, 
               n.mt1, n.mt2, n.mt3, n.mfd, n.exame, n.mf
        FROM notas n
        JOIN disciplinas d ON n.disciplina_id = d.id
        WHERE n.aluno_id = ? AND n.ano_lectivo = ?
    ");
    $stmt->bind_param("is", $aluno_id, $ano_lectivo);
    $stmt->execute();
    $result = $stmt->get_result();

    while ($row = $result->fetch_assoc()) {
        $notas[] = [
            'disciplina' => $row['disciplina'],$anos = [

    ['ano_lectivo' => '2021/2022', 'turma' => '10ª A'],
    ['ano_lectivo' => '2022/2023', 'turma' => '11ª A'],
    ['ano_lectivo' => '2023/2024', 'turma' => '12ª A'],
    ['ano_lectivo' => '2024/2025', 'turma' => '13ª A'],

            'mt1' => $row['mt1'],
            'mt2' => $row['mt2'],
            'mt3' => $row['mt3'],
            'mfd' => $row['mfd'],
            'exame' => $row['exame'],
            'mf' => $row['mf']
        ];
    }

    return $notas;
}


?>
<!DOCTYPE html>
<html lang="pt">
<head>
  <meta charset="UTF-8">
  <title>Termo do Aluno</title>
  <style>
    body {
      font-family: Arial, sans-serif;
      margin: 30px;
    }
    .cabecalho {
      text-align: center;
      margin-bottom: 20px;
      position: relative;
    }
    .foto-passe {
      position: absolute;
      right: 30px;
      top: 0;
      width: 100px;
      height: 120px;
      border: 1px solid #000;
      background-color: #eee;
    }
    .dados {
      margin-top: 10px;
      font-size: 15px;
      line-height: 1.6;
      text-align: justify;
    }
    .tabela-dupla {
      display: flex;
      flex-wrap: wrap;
      gap: 15px;
      justify-content: space-between;
    }
    .tabela-bloco {
      width: 48%;
    }
    table {
      border-collapse: collapse;
      width: 100%;
      font-size: 13px;
      margin-top: 20px;
    }
    th, td {
      border: 1px solid #333;
      padding: 4px;
      text-align: center;
    }
    caption {
      text-align: left;
      font-weight: bold;
      margin-bottom: 5px;
    }
    .assinaturas {
      margin-top: 10px;
      display: flex;
      justify-content: space-between;
      font-size: 13px;
    }
    .assinaturas div {
      width: 48%;
      text-align: center;
    }
    .linha {
      margin-top: 5px;
      border-top: 1px solid #000;
      width: 80%;
      margin-left: auto;
      margin-right: auto;
    }
    @media print {
      .foto-passe { background: none; }
    }
  </style>
</head>
<body>

<div class="cabecalho">
  <!-- Insígnia centralizada -->
  <img src="insignia/insignia.png" alt="Insígnia" style="width: 90px; display: block; margin: 0 auto;">

  <h4>REPÚBLICA DE ANGOLA</h4>
  <h5>MINISTÉRIO DA EDUCAÇÃO</h5>
  <h5>MAGISTÉRIO BG 0038 5 DE OUTUBRO - CATUMBELA</h5>
  <h3>TERMO DE FREQUÊNCIA E EXAME</h3>

  <!-- Foto do aluno à direita -->
  <div class="foto-passe">FOTO</div>
</div>

<div class="dados">
  <strong>Nome:</strong> <?= htmlspecialchars($aluno['nome']) ?>,
  <strong>Filiação:</strong> <?= htmlspecialchars($aluno['filiacao']) ?>,
  <strong>Naturalidade:</strong> <?= htmlspecialchars($aluno['naturalidade']) ?>,
  <strong>Província:</strong> <?= htmlspecialchars($aluno['provincia']) ?>,
  <strong>Nascido aos:</strong> <?= date("d/m/Y", strtotime($aluno['data_nascimento'])) ?>,
  <strong>BI nº:</strong> <?= $aluno['bi_numero'] ?> emitido em <?= $aluno['bi_emissao_local'] ?> aos <?= date("d/m/Y", strtotime($aluno['bi_emissao_data'])) ?>.
</div>

<div class="tabela-dupla">
<?php foreach ($anos as $ano): 
    $anoLectivo = $ano['ano_lectivo'];
    $turma = $ano['turma'];
    $numero_ordem = rand(1, 40);
    $curso = "E.PRIM";
    $periodo = "Manhã";
   $notas = buscarNotasReais($conn, $aluno_id, $anoLectivo, $disciplinas);

   $notas_validas = array_filter($notas, fn($n) => is_numeric($n['mf']));
if (count($notas_validas)) {
    $soma = array_sum(array_column($notas_validas, 'mf'));
    $media = round($soma / count($notas_validas), 1);
    $obs = $media >= 10 ? 'Transita' : 'Não Transita';
} else {
    $media = '';
    $obs = '';
}

?>
  <div class="tabela-bloco">
    <table>
      <caption><strong>Ano Lectivo:</strong> <?= $anoLectivo ?> | 
        <strong>Nº Ordem:</strong> <?= $numero_ordem ?> | 
        <strong>Turma:</strong> <?= $turma ?> | 
        <strong>Curso:</strong> <?= $curso ?> | 
        <strong>Período:</strong> <?= $periodo ?>
      </caption>
      <thead>
        <tr>
          <th>Disciplinas</th>
          <th>MT1</th>
          <th>MT2</th>
          <th>MT3</th>
          <th>MFD</th>
          <th>Exame</th>
          <th>MF</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($notas as $n): ?>
          <tr>
            <td><?= $n['disciplina'] ?></td>
            <td><?= $n['mt1'] ?></td>
            <td><?= $n['mt2'] ?></td>
            <td><?= $n['mt3'] ?></td>
            <td><?= $n['mfd'] ?></td>
            <td><?= $n['exame'] ?></td>
            <td><?= $n['mf'] ?></td>
          </tr>
        <?php endforeach; ?>
        <tr>
          <td colspan="6"><strong>Média Final:</strong></td>
          <td><strong><?= $media ?></strong></td>
        </tr>
        <tr>
          <td colspan="6"><strong>Observação:</strong></td>
          <td><strong><?= $obs ?></strong></td>
        </tr>
      </tbody>
    </table>

    <div class="assinaturas">
      <div>
        Assinatura do Diretor da Turma
        <div class="linha">______________________</div>
      </div>
      <div>
        Assinatura do Subdiretor Pedagógico
        <div class="linha">______________________</div>
      </div>
    </div>
  </div>
<?php endforeach; ?>
</div>

</body>
</html>
